<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="QUMT_MT900011NL">
    <title>Content Subscription Signal</title>

    <title>InformEvent/informationRecipient</title>
    <rule context="$element/hl7:informationRecipient">
        <assert role="error" test="hl7:assignedPerson/hl7:id"
            >assignedPerson/id is verplicht</assert>
        <assert role="error" test="hl7:assignedPerson/hl7:telecom"
            >assignedPerson/telecom is verplicht</assert>
        <assert role="error" test="hl7:assignedPerson/hl7:Organization/hl7:id"
            >assignedPerson/Organization/id is verplicht</assert>
    </rule>
    <rule context="$element/hl7:informationRecipient/hl7:assignedPerson/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@nullFlavor or (@root='2.16.840.1.113883.2.4.6.3' and @extension)"
            >assignedPerson/id/@root moet '2.16.840.1.113883.2.4.6.3' zijn en @extension moet een geldige waarde bevatten</assert>
    </rule>
    <rule context="$element/hl7:informationRecipient/hl7:assignedPerson/hl7:telecom">
        <extends rule="TEL"/>
        <assert role="error" test="substring(@value,1,43)='x-hl7-applicatie:2.16.840.1.113883.2.4.6.6.'"
            >assignedPerson/telecom moet een AORTA applicatie-id zijn</assert>
    </rule>
    <rule context="$element/hl7:informationRecipient/hl7:assignedPerson/hl7:Organization/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.25' and @extension"
            >assignedPerson/Organization/id/@root moet '2.16.840.1.113883.2.4.3.11.25' zijn en @extension moet een geldige waarde bevatten</assert>
    </rule>

    <title>InformEvent/subjectOf/controlActEvent</title>
    <rule context="$element/hl7:subjectOf/hl7:controlActEvent">
        <assert role="warn" test="hl7:subject1"
            >waarschuwing: subject1 ontbreekt. Op dit moment zijn er nog geen signalen bekend zonder gebeurtenis-subject</assert>
    </rule>
    <rule context="$element/hl7:subjectOf/hl7:controlActEvent/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.14' and @extension"
            >controlActEvent/id/@root moet '2.16.840.1.113883.2.4.3.11.14' zijn en @extension moet een geldige waarde bevatten</assert>
    </rule>
    <rule context="$element/hl7:subjectOf/hl7:controlActEvent/hl7:code">
        <extends rule="CV"/>
        <assert role="error" test="(@codeSystem='2.16.840.1.113883.2.4.3.11.12' or @codeSystem='2.16.840.1.113883.2.4.3.11.18') and @code"
            >controlActEvent/code/@codeSystem moet '2.16.840.1.113883.2.4.3.11.12' of '2.16.840.1.113883.2.4.3.11.18' zijn en @code moet een geldige waarde bevatten</assert>
    </rule>

    <title>InformEvent/inFulFillmentOf/subscription</title>
    <rule context="$element/hl7:inFulfillmentOf/hl7:subscription/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:inFulfillmentOf/hl7:subscription/hl7:statusCode">
        <extends rule="CS"/>
        <assert role="error" test="@code='active' or @code='cancelled'"
            >subscription/statusCode moet 'active' of 'cancelled' zijn</assert>
    </rule>
</pattern>
